<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php hooks()->do_action('app_customers_portal_head'); ?>

<style>
    .device-card-item {
        display: flex;
        margin-bottom: 25px;
    }
    .device-card-panel {
        width: 100%;
        display: flex;
        flex-direction: column;
        margin-bottom: 0;
        border: 1px solid #e5e7eb;
        border-radius: 8px;
        box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
        background: #fff;
        transition: transform 0.2s;
    }
    .device-card-panel:hover {
        transform: translateY(-2px);
        box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05);
    }
    .device-image-container {
        height: 180px;
        overflow: hidden;
        border-top-left-radius: 8px;
        border-top-right-radius: 8px;
        background: #f9fafb;
        display: flex;
        align-items: center;
        justify-content: center;
        border-bottom: 1px solid #f3f4f6;
    }
    .device-image {
        max-height: 100%;
        object-fit: cover;
        width: 100%;
    }
    .device-status-indicator {
        position: absolute;
        top: 10px;
        right: 10px;
        padding: 4px 8px;
        border-radius: 4px;
        font-size: 11px;
        font-weight: 600;
        text-transform: uppercase;
        color: #fff;
        box-shadow: 0 2px 4px rgba(0,0,0,0.1);
    }
</style>

<div class="col-md-12">
    <div class="row">
        <div class="col-md-6">
            <h4 class="tw-mt-0 tw-font-semibold tw-text-neutral-700 section-heading section-heading-invoices">
                <?php echo e($title); ?>
            </h4>
        </div>
        <div class="col-md-6 text-right">
             <div class="btn-group" role="group">
                <button type="button" class="btn btn-default active" id="btn-grid-view" onclick="wshop_switch_view('grid')"><i class="fa fa-th-large"></i></button>
                <button type="button" class="btn btn-default" id="btn-list-view" onclick="wshop_switch_view('list')"><i class="fa fa-list"></i></button>
            </div>
        </div>
    </div>

    <!-- GRID VIEW -->
    <div id="wshop-grid-view">
        <div class="row" style="display: flex; flex-wrap: wrap;">
            <?php foreach($devices as $device){ 
                 $image_url = site_url('modules/workshop/assets/images/upload-image-icon.png');
                 if ($device['primary_profile_image'] != '' && file_exists(MAIN_IMAGE_DEVICES_IMAGES_FOLDER.$device['id'].'/'.$device['primary_profile_image'])) {
                     $image_url = site_url('modules/workshop/uploads/main_image_devices/'.$device['id'].'/'.$device['primary_profile_image']);
                 }

                 $status_color = '#777'; 
                 $status_text = _l('wshop_inactive');
                 if(isset($device['status'])){
                    if($device['status'] == 1){
                        $status_color = '#84c529'; $status_text = _l('wshop_active');
                    } elseif($device['status'] == 2){
                        $status_color = '#fc2d42'; $status_text = _l('wshop_under_repair');
                    } elseif($device['status'] == 3){
                        $status_color = '#ff9900'; $status_text = _l('wshop_waiting_repair');
                    }
                 }
                 
                 $category_name = '';
                 $manufacturer_name = '';
                 $model = wshop_get_model($device['model_id']);
                 if($model){
                    $category_name = wshop_get_category_name($model->category_id);
                    $manufacturer_name = wshop_get_manufacturer_name($model->manufacturer_id);
                 }
            ?>
            <div class="col-lg-4 col-md-6 col-sm-6 device-card-item">
                <div class="device-card-panel">
                    <div style="position: relative;">
                         <div class="device-image-container">
                            <img src="<?php echo $image_url; ?>" class="device-image">
                         </div>
                         <div class="device-status-indicator" style="background-color: <?php echo $status_color; ?>;">
                             <?php echo $status_text; ?>
                         </div>
                    </div>
                    
                    <div class="panel-body" style="flex: 1; display: flex; flex-direction: column;">
                         <h4 class="bold no-margin" style="white-space: nowrap; overflow: hidden; text-overflow: ellipsis;">
                            <a href="<?php echo site_url('workshop/client/device_detail/'.$device['id']) ?>" class="text-dark">
                                <?php echo $device['name']; ?>
                            </a>
                        </h4>
                         <p class="text-muted small mtop5" style="margin-bottom: 10px;">
                             <?php echo $device['code']; ?> 
                             <?php if(!empty($device['plate_number'])) { echo ' | ' . $device['plate_number']; } ?>
                         </p>
                         
                         <hr style="margin: 10px 0;">
                         
                         <div class="row">
                             <div class="col-xs-6">
                                 <span class="text-muted small"><?php echo _l('wshop_model'); ?></span><br>
                                 <span class="bold"><?php echo wshop_get_model_name($device['model_id']); ?></span>
                             </div>
                             <div class="col-xs-6 text-right">
                                 <span class="text-muted small"><?php echo _l('wshop_category'); ?></span><br>
                                 <span class="bold"><?php echo $category_name; ?></span>
                             </div>
                         </div>
                         
                         <div class="mtop15" style="margin-top: auto;">
                             <a href="<?php echo site_url('workshop/client/device_detail/'.$device['id']) ?>" class="btn btn-default btn-block">
                                 <?php echo _l('view'); ?>
                             </a>
                         </div>
                    </div>
                </div>
            </div>
            <?php } ?>
        </div>
    </div>

    <!-- LIST VIEW -->
    <div id="wshop-list-view" class="hide">
        <div class="panel_s">
            <div class="panel-body">
                <table class="table dt-table table-requests" data-order-col="1" data-order-type="desc">
                    <thead>
                        <tr>
                            <th class="th-invoice-number"><?php echo _l('wshop_image'); ?></th>
                            <th class="th-invoice-number"><?php echo _l('wshop_code'); ?></th>
                            <th class="th-invoice-number"><?php echo _l('wshop_name'); ?></th>
                            <th class="th-invoice-number"><?php echo _l('wshop_serial_no'); ?></th>
                            <th class="th-invoice-number"><?php echo _l('client'); ?></th>
                            <th class="th-invoice-number"><?php echo _l('wshop_model'); ?></th>
                            <th class="th-invoice-number"><?php echo _l('wshop_category'); ?></th>
                            <th class="th-invoice-number"><?php echo _l('wshop_manufacturer'); ?></th>
                            <th class="th-invoice-number"><?php echo _l('wshop_purchase_date'); ?></th>
                            <th class="th-invoice-number"><?php echo _l('wshop_last_maintenance_date'); ?></th>
                            <th class="th-invoice-number"><?php echo _l('wshop_next_maintenance_date'); ?></th>
                            <th class="th-invoice-number"><?php echo _l('wshop_warranty_period_months'); ?></th>
                            <th class="th-invoice-number"><?php echo _l('wshop_warranty_expiry_date'); ?></th>
                            <th class="th-invoice-number"><?php echo _l('wshop_warranty_status'); ?></th>
                            <th class="th-invoice-number"><?php echo _l('options'); ?></th>
                            
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach($devices as $device){ ?>
                            <?php 
                            $CI = &get_instance();

                            if ($device['primary_profile_image'] != '' && file_exists(MAIN_IMAGE_DEVICES_IMAGES_FOLDER.$device['id'].'/'.$device['primary_profile_image'])) {
                                $device_image = '<img class="manufacturer-img" id="wizardPicturePreview" src="' . site_url('modules/workshop/uploads/main_image_devices/'.$device['id'].'/'.$device['primary_profile_image']) . '" alt="'.$device['primary_profile_image'].'" >';
                            }else{
                                $device_image = '<img class="manufacturer-img" id="wizardPicturePreview" src="' . site_url('modules/workshop/assets/images/upload-image-icon.png') . '" >';
                            }
                            $category_name = '';
                            $manufacturer_name = '';
                            $model = wshop_get_model($device['model_id']);
                            if($model){
                                $category_name = wshop_get_category_name($model->category_id);
                                $manufacturer_name = wshop_get_manufacturer_name($model->manufacturer_id);
                            }

                            $warranty_status = '---';
                            if($device['warranty_expiry_date'] != null){
                                if(strtotime($device['warranty_expiry_date']) > strtotime(date('Y-m-d'))){
                                    $warranty_status = '<span class="label label-success">'._l('wshop_being_under_warranty').'</span>';
                                }else{
                                    $warranty_status = '<span class="label label-warning">'._l('wshop_out_of_warranty').'</span>';
                                }
                            }
                            ?>
                            <tr>
                                <td data-order="<?php echo new_html_entity_decode($device['id']); ?>"><?php echo html_entity_decode($device_image) ?></td>
                                <td data-order="<?php echo new_html_entity_decode($device['code']); ?>"><?php echo new_html_entity_decode(($device['code'])); ?></td>
                                <td data-order="<?php echo new_html_entity_decode($device['name']); ?>"><a href="<?php echo site_url('workshop/client/device_detail/'.$device['id']) ?>"><?php echo new_html_entity_decode(($device['name'])); ?></a></td>
                                <td data-order="<?php echo new_html_entity_decode($device['serial_no']); ?>"><?php echo new_html_entity_decode(($device['serial_no'])); ?></td>
                                <td data-order="<?php echo get_company_name($device['client_id']); ?>"><?php echo new_html_entity_decode(get_company_name($device['client_id'])); ?></td>
                                <td data-order="<?php echo new_html_entity_decode($device['model_id']); ?>"><?php echo new_html_entity_decode(wshop_get_model_name($device['model_id'])); ?></td>
                                <td data-order="<?php echo new_html_entity_decode($device['model_id']); ?>"><?php echo new_html_entity_decode($category_name); ?></td>
                                <td data-order="<?php echo new_html_entity_decode($device['model_id']); ?>"><?php echo new_html_entity_decode($manufacturer_name); ?></td>
                                <td data-order="<?php echo new_html_entity_decode($device['purchase_date']); ?>"><?php echo  _dt($device['purchase_date']); ?></td>
                                <td data-order="<?php echo new_html_entity_decode($device['purchase_date']); ?>"><?php echo html_entity_decode(_d($device['last_maintenance'])); ?></td>
                                <td data-order="<?php echo new_html_entity_decode($device['purchase_date']); ?>"><?php echo html_entity_decode(_d($device['next_maintenance'])); ?></td>
                                <td data-order="<?php echo new_html_entity_decode($device['warranty_period_months']); ?>"><?php echo new_html_entity_decode($device['warranty_period_months']).' '._l('wshop_months') ; ?></td>
                                <td data-order="<?php echo new_html_entity_decode($device['warranty_expiry_date']); ?>"><?php echo _d($device['warranty_expiry_date']); ?></td>

                                <td data-order="<?php echo new_html_entity_decode($device['warranty_expiry_date']); ?>" ><?php echo new_html_entity_decode($warranty_status); ?></td>

                                <?php 
                                $option = '';
                                $option .='<a href="'. site_url('workshop/client/device_detail/'.$device['id']).'" class="btn btn-default btn-icon mright5" data-toggle="tooltip" data-title="'._l('view').'" data-placement="bottom"><i class="fa-regular fa-eye"></i></a>';

                                $_data = $option;
                                ?>
                                <td data-order="<?php echo new_html_entity_decode($device['id']); ?>"><?php echo new_html_entity_decode($option); ?></td>

                            </tr>
                        <?php } ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<script>
    function wshop_switch_view(view) {
        if (view == 'grid') {
            $('#wshop-grid-view').removeClass('hide');
            $('#wshop-list-view').addClass('hide');
            $('#btn-grid-view').addClass('active');
            $('#btn-list-view').removeClass('active');
        } else {
            $('#wshop-grid-view').addClass('hide');
            $('#wshop-list-view').removeClass('hide');
            $('#btn-grid-view').removeClass('active');
            $('#btn-list-view').addClass('active');
        }
    }
</script>

<?php workshop_client_init_tail(); ?>